<?php

use Joomla\Registry\Registry;

// no direct access
defined('_JEXEC') or die;

jimport('joomla.log.log');

class plgContentVitagateteaser extends JPlugin
{

	/**
	 * The build number.
	 */
	const BUILD = 101;

	/**
	 * The log category.
	 */
	const LOG_CATEGORY = 'vitagateteaser';

	/**
	 * Load the language file on instantiation. Note this is only available in Joomla 3.1 and higher.
	 * If you want to support 3.0 series you must override the constructor
	 *
	 * @var    boolean
	 * @since  3.1
	 */
	protected $autoloadLanguage = true;

	/**
	 * @param string $text
	 * @param string $teasers
	 *
	 * @return string
	 */
	protected function _placeTeasers($text, $teasers = '')
	{
		$text = str_replace('<p>[vitagate_teaser]</p>', $teasers, $text);
		$text = str_replace('[vitagate_teaser]', $teasers, $text);

		return $text;
	}

	/**
	 * Plugin method with the same name as the event will be called automatically.
	 */
	function onContentPrepare($context, $article, $params, $limitstart)
	{
		$plugin = JPluginHelper::getPlugin('content', 'vitagateteaser');
		if (!$plugin)
		{
			return true;
		}

		// Get plugin params
		$pluginParams  = new Registry($plugin->params);
		$logEnabled    = $pluginParams->get('logEnabled', false);
		$vak           = $pluginParams->get('vak');
		$itemsTemplate = $pluginParams->get('items_template');
		$itemTemplate  = $pluginParams->get('item_template');

		if ($logEnabled)
		{
			JLog::addLogger(array('text_file' => 'vitagateteaser.log.php'), JLog::ALL, array(self::LOG_CATEGORY));
		}

		$langTag = JFactory::getLanguage()->getTag();
		if ('fr' === substr($langTag, 0, 2))
		{
			$lang = 'fr';
		}
		else
		{
			if ('de' === substr($langTag, 0, 2))
			{
				$lang = 'de';
			}
			else
			{
				// Languages other than the ones defined by vitagate would just be ignored.
				if ($logEnabled)
				{
					JLog::add('Unsupported language: ' . $langTag, JLog::INFO, self::LOG_CATEGORY);
				}

				$article->text = $this->_placeTeasers($article->text, '');

				return true;
			}
		}

		$data = null;
		$path = JPATH_CACHE . DIRECTORY_SEPARATOR . 'vitagateteaser.' . $lang . '.json';
		if (is_file($path))
		{
			$json = file_get_contents($path);
			$data = json_decode($json);
		}

		// Get some system objects.
		$config = JFactory::getConfig();

		// Get a date object based on user settings.
		$date = JFactory::getDate('now', $config->get('offset'));

		if (is_null($data) || $date->format('Ymd') !== $data->server_date)
		{
			$url = 'https://vitagate.ch/' . $lang . '/rss/front.json?build=' . self::BUILD . '&vak=' . $vak;
			if ($logEnabled)
			{
				JLog::add('Fetch Service: ' . $url, JLog::INFO, self::LOG_CATEGORY);
			}

			$curlParams      = array('follow_location' => true);
			$transportParams = new Registry($curlParams);
			$http            = JHttpFactory::getHttp($transportParams, 'curl');
			$response        = $http->get($url);

			if ($logEnabled && $response->code !== 200)
			{
				JLog::add('Invalid remote http response code: ' . $response->code, JLog::INFO, self::LOG_CATEGORY);
			}

			file_put_contents($path, $response->body);
			$data = json_decode($response->body);
		}

		if (is_null($data))
		{
			if ($logEnabled)
			{
				JLog::add('No teaser data found.', JLog::INFO, self::LOG_CATEGORY);
			}

			$article->text = $this->_placeTeasers($article->text, '');

			return true;
		}

		if ('OK' !== $data->status)
		{
			if ($logEnabled)
			{
				JLog::add('Invalid Data Status: ' . $data->status, JLog::INFO, self::LOG_CATEGORY);
			}

			$article->text = $this->_placeTeasers($article->text, '');

			return true;
		}

		$amount    = 0;
		$itemsHtml = '';
		foreach ($data->items as $item)
		{
			$t = $itemTemplate;

			$t = str_replace('[title]', $item->title, $t);
			$t = str_replace('[link]', $item->link, $t);
			$t = str_replace('[lead]', $item->description, $t);
			$t = str_replace('[image.url]', $item->image->url, $t);
			$t = str_replace('[image.alt]', htmlspecialchars($item->image->alt, ENT_QUOTES), $t);
			$t = str_replace('[image.copyright]', htmlspecialchars($item->image->copyright, ENT_QUOTES), $t);

			$itemsHtml .= $t;

			$amount++;
			if ($amount > 3)
			{
				break;
			}
		}

		$article->text = $this->_placeTeasers($article->text, str_replace('[items]', $itemsHtml, $itemsTemplate));

		return true;
	}
}
